/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;

@BoxBIF
@BoxMember(type=BoxLangType.NUMERIC)
public class Fix
extends BIF {
    public Fix() {
        this.declaredArguments = new Argument[]{new Argument(true, "numeric", Key.number)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Number number = arguments.getAsNumber(Key.number);
        if (number instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)number;
            if (bd.compareTo(BigDecimal.ZERO) == 0) {
                return bd;
            }
            return bd.compareTo(BigDecimal.ZERO) > 0 ? bd.setScale(0, RoundingMode.FLOOR) : bd.setScale(0, RoundingMode.CEILING);
        }
        double d = number.doubleValue();
        if (d == 0.0) {
            return number;
        }
        return d > 0.0 ? StrictMath.floor(d) : StrictMath.ceil(d);
    }
}

