/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
@BoxMember(type=BoxLangType.NUMERIC)
public class FormatBaseN
extends BIF {
    public FormatBaseN() {
        this.declaredArguments = new Argument[]{new Argument(true, "numeric", Key.number), new Argument(true, "integer", Key.radix)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Number number = arguments.getAsNumber(Key.number);
        int radix = arguments.getAsInteger(Key.radix);
        if (radix < 2 || radix > 36) {
            throw new BoxRuntimeException("Radix out of valid range");
        }
        if (number instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)number;
            BigInteger bigInt = bd.toBigInteger();
            return bigInt.toString(radix);
        }
        return Long.toString((long)((Integer)number).intValue() & 0xFFFFFFFFL, radix);
    }
}

