/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.util.MathUtil;
import ortus.boxlang.runtime.validation.Validator;

@BoxBIF
@BoxMember(type=BoxLangType.STRING, name="InputBaseN")
public class InputBaseN
extends BIF {
    public InputBaseN() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.string, Set.of(Validator.NON_EMPTY)), new Argument(true, "integer", Key.radix, Set.of(Validator.min(2), Validator.max(36)))};
    }

    @Override
    public Number _invoke(IBoxContext context, ArgumentsScope arguments) {
        String string = arguments.getAsString(Key.string);
        int radix = arguments.getAsInteger(Key.radix);
        if (string.startsWith("0x")) {
            string = string.substring(2, string.length());
        }
        BigInteger bigInt = new BigInteger(string, radix);
        return new BigDecimal(bigInt, MathUtil.getMathContext());
    }
}

