/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import java.math.MathContext;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.global.math.Exp;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.util.MathUtil;

@BoxBIF
@BoxMember(type=BoxLangType.NUMERIC)
public class Log
extends BIF {
    public Log() {
        this.declaredArguments = new Argument[]{new Argument(true, "numeric", Key.number)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Number number = arguments.getAsNumber(Key.number);
        if (number instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)number;
            return Log.log(bd, MathUtil.getMathContext());
        }
        return StrictMath.log(number.doubleValue());
    }

    public static BigDecimal log(BigDecimal value, MathContext mc) {
        BigDecimal exp;
        BigDecimal diff;
        if (value.compareTo(BigDecimal.ZERO) <= 0) {
            throw new ArithmeticException("Logarithm of non-positive value");
        }
        BigDecimal x = BigDecimal.valueOf(Math.log(value.doubleValue()));
        BigDecimal tolerance = BigDecimal.ONE.scaleByPowerOfTen(-mc.getPrecision());
        int maxIterations = 1000;
        for (int iteration = 0; iteration < maxIterations && (diff = value.subtract(exp = Exp.exp(x, mc), mc)).abs().compareTo(tolerance) >= 0; ++iteration) {
            x = x.add(diff.divide(exp, mc), mc);
        }
        return x;
    }
}

