/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import java.math.MathContext;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.util.MathUtil;

@BoxBIF
@BoxMember(type=BoxLangType.NUMERIC)
public class Log10
extends BIF {
    public Log10() {
        this.declaredArguments = new Argument[]{new Argument(true, "numeric", Key.number)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Number number = arguments.getAsNumber(Key.number);
        if (number instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)number;
            return Log10.log10(bd, MathUtil.getMathContext());
        }
        return StrictMath.log10(number.doubleValue());
    }

    public static BigDecimal log10(BigDecimal value, MathContext mc) {
        BigDecimal exp;
        BigDecimal diff;
        if (value.compareTo(BigDecimal.ZERO) <= 0) {
            throw new ArithmeticException("Logarithm of non-positive value");
        }
        BigDecimal x = BigDecimal.valueOf(Math.log10(value.doubleValue()));
        BigDecimal tolerance = BigDecimal.ONE.scaleByPowerOfTen(-mc.getPrecision());
        int maxIterations = 1000;
        for (int iteration = 0; iteration < maxIterations && (diff = value.subtract(exp = Log10.exp10(x, mc), mc)).abs().compareTo(tolerance) >= 0; ++iteration) {
            x = x.add(diff.divide(exp.multiply(BigDecimal.valueOf(Math.log(10.0)), mc), mc), mc);
        }
        return x;
    }

    private static BigDecimal exp10(BigDecimal x, MathContext mc) {
        BigDecimal result = BigDecimal.ONE;
        BigDecimal term = BigDecimal.ONE;
        BigDecimal ln10 = BigDecimal.valueOf(Math.log(10.0));
        int n = 1;
        BigDecimal threshold = new BigDecimal("1E-10");
        while (term.abs().compareTo(threshold) > 0) {
            term = term.multiply(x.multiply(ln10, mc), mc).divide(BigDecimal.valueOf(n), mc);
            result = result.add(term, mc);
            ++n;
        }
        return result;
    }
}

