/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BigDecimalCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;

@BoxBIF
public class Min
extends BIF {
    public Min() {
        this.declaredArguments = new Argument[]{new Argument(true, "numeric", Key.number1), new Argument(true, "numeric", Key.number2)};
    }

    @Override
    public Number _invoke(IBoxContext context, ArgumentsScope arguments) {
        Number number1 = arguments.getAsNumber(Key.number1);
        Number number2 = arguments.getAsNumber(Key.number2);
        return Min._invoke(number1, number2);
    }

    public static Number _invoke(Number number1, Number number2) {
        boolean isNumber1 = number1 instanceof BigDecimal;
        boolean isNumber2 = number2 instanceof BigDecimal;
        if (isNumber1 || isNumber2) {
            BigDecimal bdl = isNumber1 ? (BigDecimal)number1 : BigDecimalCaster.cast(number1);
            BigDecimal bdr = isNumber2 ? (BigDecimal)number2 : BigDecimalCaster.cast(number2);
            return bdl.min(bdr);
        }
        return StrictMath.min(number1.doubleValue(), number2.doubleValue());
    }
}

