/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.MathUtil;

@BoxBIF
public class PrecisionEvaluate
extends BIF {
    private static final Pattern pattern = Pattern.compile("^[0-9+\\-*/^%\\\\()\\s]*(MOD\\s*)?[0-9+\\-*/^%\\\\()\\s]*$");

    public PrecisionEvaluate() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.expressions)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String expressions = arguments.getAsString(Key.expressions);
        CastAttempt<Number> numberCast = NumberCaster.attempt(expressions);
        if (numberCast.wasSuccessful()) {
            return numberCast.get();
        }
        Matcher matcher = pattern.matcher(expressions);
        if (matcher.matches()) {
            Number results;
            try {
                results = (Number)this.runtime.executeStatement(expressions, context);
            }
            catch (Exception e) {
                throw new BoxRuntimeException("Error evaluating expression: " + e.getMessage(), e);
            }
            return new BigDecimal(results.doubleValue(), MathUtil.getMathContext());
        }
        throw new BoxRuntimeException("The expressions provided are not valid");
    }
}

