/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.global.math.Rand;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BigDecimalCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.MathUtil;

@BoxBIF
public class RandRange
extends BIF {
    public RandRange() {
        this.declaredArguments = new Argument[]{new Argument(true, "numeric", Key.number1), new Argument(true, "numeric", Key.number2), new Argument(false, "string", Key.algorithm)};
    }

    @Override
    public Number _invoke(IBoxContext context, ArgumentsScope arguments) {
        if (arguments.get(Key.algorithm) != null) {
            throw new BoxRuntimeException("The algorithm argument has not yet been implemented");
        }
        Number number1 = arguments.getAsNumber(Key.number1);
        Number number2 = arguments.getAsNumber(Key.number2);
        Long seed = (Long)context.getAttachment(Key.bxRandomSeed);
        boolean isNumber1 = number1 instanceof BigDecimal;
        boolean isNumber2 = number2 instanceof BigDecimal;
        if (isNumber1 || isNumber2) {
            BigDecimal bdl = isNumber1 ? (BigDecimal)number1 : BigDecimalCaster.cast(number1);
            BigDecimal bdr = isNumber2 ? (BigDecimal)number2 : BigDecimalCaster.cast(number2);
            return bdl.add(new BigDecimal(Rand._invoke(seed), MathUtil.getMathContext()).multiply(bdr.subtract(bdl))).setScale(0, RoundingMode.DOWN);
        }
        long lower = number1.longValue();
        long upper = number2.longValue();
        return lower + (long)(Rand._invoke(seed) * (double)(upper - lower + 1L));
    }
}

