/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;

@BoxBIF
@BoxMember(type=BoxLangType.NUMERIC, name="sgn")
public class Sgn
extends BIF {
    public Sgn() {
        this.declaredArguments = new Argument[]{new Argument(true, "numeric", Key.number)};
    }

    @Override
    public Integer _invoke(IBoxContext context, ArgumentsScope arguments) {
        Number number = arguments.getAsNumber(Key.number);
        if (number instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)number;
            return bd.signum();
        }
        if (number.doubleValue() > 0.0) {
            return 1;
        }
        if (number.doubleValue() < 0.0) {
            return -1;
        }
        return 0;
    }
}

