/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import java.math.MathContext;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.util.MathUtil;

@BoxBIF
@BoxMember(type=BoxLangType.NUMERIC, name="Sin")
public class Sin
extends BIF {
    public Sin() {
        this.declaredArguments = new Argument[]{new Argument(true, "numeric", Key.number)};
    }

    @Override
    public Number _invoke(IBoxContext context, ArgumentsScope arguments) {
        Number value = arguments.getAsNumber(Key.number);
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            return Sin.sin(bd, MathUtil.getMathContext());
        }
        return StrictMath.sin(value.doubleValue());
    }

    public static BigDecimal sin(BigDecimal x, MathContext mc) {
        return new BigDecimal(StrictMath.sin(x.doubleValue()));
    }
}

