/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.util.MathUtil;

@BoxBIF
@BoxMember(type=BoxLangType.NUMERIC)
public class Sqr
extends BIF {
    public Sqr() {
        this.declaredArguments = new Argument[]{new Argument(true, "numeric", Key.value)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Number number = arguments.getAsNumber(Key.value);
        if (number instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)number;
            return bd.sqrt(MathUtil.getMathContext());
        }
        return StrictMath.sqrt(number.doubleValue());
    }
}

