/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.math;

import java.math.BigDecimal;
import java.math.MathContext;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.global.math.Cos;
import ortus.boxlang.runtime.bifs.global.math.Sin;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.util.MathUtil;

@BoxBIF
@BoxMember(type=BoxLangType.NUMERIC)
public class Tan
extends BIF {
    public Tan() {
        this.declaredArguments = new Argument[]{new Argument(true, "numeric", Key.number)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Number value = arguments.getAsNumber(Key.number);
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            return Tan.tan(bd, MathUtil.getMathContext());
        }
        return StrictMath.tan(value.doubleValue());
    }

    public static BigDecimal tan(BigDecimal x, MathContext mc) {
        BigDecimal sinX = Sin.sin(x, mc);
        BigDecimal cosX = Cos.cos(x, mc);
        return sinX.divide(cosX, mc);
    }
}

