/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.query;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.QueryColumnType;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
@BoxMember(type=BoxLangType.QUERY)
public class QueryAddColumn
extends BIF {
    public QueryAddColumn() {
        this.declaredArguments = new Argument[]{new Argument(true, "query", Key.query), new Argument(true, "string", Key.columnName), new Argument(false, "any", Key.datatype, "Varchar"), new Argument(false, "array", Key.array, new Array())};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Query query = arguments.getAsQuery(Key.query);
        String columnName = arguments.getAsString(Key.columnName);
        String columnType = "";
        Array array = arguments.getAsArray(Key.array);
        if (query.getColumns().containsKey(Key.of(columnName))) {
            throw new BoxRuntimeException("Column '" + columnName + "' already exists in the query.");
        }
        Object object = arguments.get(Key.datatype);
        if (object instanceof Array) {
            Array castedArray;
            array = castedArray = (Array)object;
            columnType = "Varchar";
        } else {
            columnType = arguments.getAsString(Key.datatype);
        }
        QueryColumnType queryColumnType = QueryColumnType.fromString(columnType);
        if (array.isEmpty()) {
            for (int i = 0; i < query.size(); ++i) {
                array.add("");
            }
        }
        query.addColumn(Key.of(columnName), queryColumnType, array.toArray());
        return query.getColumns().size();
    }
}

