/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.query;

import java.util.Map;
import java.util.UUID;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.AsyncService;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.QueryColumn;
import ortus.boxlang.runtime.types.util.BLCollector;

@BoxBIF
@BoxMember(type=BoxLangType.QUERY)
public class QueryFilter
extends BIF {
    public QueryFilter() {
        this.declaredArguments = new Argument[]{new Argument(true, "query", Key.query), new Argument(true, "function:Predicate", Key.callback), new Argument(false, "boolean", Key.parallel, false), new Argument(false, "integer", Key.maxThreads)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Query query = arguments.getAsQuery(Key.query);
        Function callback = arguments.getAsFunction(Key.callback);
        Boolean parallel = arguments.getAsBoolean(Key.parallel);
        Integer maxThreads = arguments.getAsInteger(Key.maxThreads);
        IntPredicate test = callback.requiresStrictArguments() ? idx -> BooleanCaster.cast(context.invokeFunction((Object)callback, new Object[]{query.getRowAsStruct(idx)})) : idx -> BooleanCaster.cast(context.invokeFunction((Object)callback, new Object[]{query.getRowAsStruct(idx), idx + 1, query}));
        IntStream intStream = query.intStream();
        Query newQuery = new Query();
        for (Map.Entry<Key, QueryColumn> column : query.getColumns().entrySet()) {
            newQuery.addColumn(column.getKey(), column.getValue().getType());
        }
        if (parallel.booleanValue()) {
            return AsyncService.buildExecutor("QueryFilter_" + UUID.randomUUID().toString(), AsyncService.ExecutorType.FORK_JOIN, maxThreads).submitAndGet(() -> query.intStream().parallel().filter(test).mapToObj(query::getRowAsStruct).collect(BLCollector.toQuery(newQuery)));
        }
        return intStream.filter(test).mapToObj(query::getRowAsStruct).collect(BLCollector.toQuery(newQuery));
    }
}

