/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.query;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.ListUtil;

@BoxBIF
public class QueryNew
extends BIF {
    public QueryNew() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.columnList), new Argument(false, "string", Key.columnTypeList, ""), new Argument(false, "any", Key.rowData)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Array columnNames;
        Object rowData = arguments.get(Key.rowData);
        Object columnList = arguments.get(Key.columnList);
        if (columnList instanceof String) {
            String cl = (String)columnList;
            columnNames = ArrayCaster.cast(ListUtil.asList(cl, ","));
        } else if (columnList instanceof Array) {
            Array castedRowData = (Array)columnList;
            rowData = castedRowData;
            columnNames = new Array();
            if (!castedRowData.isEmpty()) {
                columnNames = Array.fromList(StructCaster.cast(castedRowData.get(0)).getKeysAsStrings());
            }
        } else {
            throw new BoxRuntimeException("The [columnList] must be a string, or an array of data, or");
        }
        Array columnTypes = ListUtil.asList(arguments.getAsString(Key.columnTypeList), ",");
        if (columnTypes.isEmpty()) {
            for (int i = 0; i < columnNames.size(); ++i) {
                columnTypes.add("object");
            }
        } else if (columnNames.size() != columnTypes.size()) {
            throw new BoxRuntimeException("columnList and columnTypeList must have the same number of elements");
        }
        return Query.fromArray(columnNames, columnTypes, rowData);
    }
}

