/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.query;

import java.util.List;
import java.util.stream.Collectors;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
@BoxMember(type=BoxLangType.QUERY)
public class QuerySetRow
extends BIF {
    public QuerySetRow() {
        this.declaredArguments = new Argument[]{new Argument(true, "query", Key.query), new Argument(false, "integer", Key.rowNumber, 0), new Argument(true, "any", Key.rowData)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Query query = arguments.getAsQuery(Key.query);
        int rowNumber = arguments.getAsInteger(Key.rowNumber) - 1;
        Object rowData = arguments.get(Key.rowData);
        if (rowNumber < 0) {
            query.addRows(1);
            rowNumber = query.size() - 1;
        }
        List<Key> columns = query.getColumns().keySet().stream().collect(Collectors.toList());
        Object[] rowValues = new Object[columns.size()];
        this.fillRowValues(query, rowData, columns, rowValues);
        this.updateQueryData(query, rowNumber, rowValues);
        return query;
    }

    private void fillRowValues(Query query, Object rowData, List<Key> columns, Object[] rowValues) {
        if (rowData instanceof IStruct) {
            IStruct rowDataStruct = StructCaster.cast(rowData);
            columns.forEach(key -> {
                rowValues[columns.indexOf((Object)key)] = rowDataStruct.getOrDefault((Key)key, query.getCell((Key)key, columns.indexOf(key)));
            });
        } else if (rowData instanceof Array) {
            Array rowDataArray = ArrayCaster.cast(rowData);
            for (int i = 0; i < columns.size(); ++i) {
                rowValues[i] = i < rowDataArray.size() ? rowDataArray.get(i) : null;
            }
        } else {
            throw new BoxRuntimeException("Invalid row data type: " + rowData.getClass().getSimpleName());
        }
    }

    private void updateQueryData(Query query, int rowNumber, Object[] rowValues) {
        if (query.getRow(rowNumber) == null) {
            query.getData().add(rowValues);
        } else {
            query.getData().set(rowNumber, rowValues);
        }
    }
}

