/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.query;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.QueryColumn;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
@BoxMember(type=BoxLangType.QUERY)
public class QuerySlice
extends BIF {
    public QuerySlice() {
        this.declaredArguments = new Argument[]{new Argument(true, "query", Key.query), new Argument(true, "integer", Key.offset), new Argument(false, "integer", Key.length, 0)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Query query = arguments.getAsQuery(Key.query);
        int offset = arguments.getAsInteger(Key.offset) - 1;
        int length = arguments.getAsInteger(Key.length);
        if (offset < 0 && (offset += query.size()) < 0) {
            throw new BoxRuntimeException("Offset is outside the query row range.");
        }
        if (offset >= query.size() - 1) {
            throw new BoxRuntimeException("Offset is outside the query row range.");
        }
        if (offset + length - 1 >= query.size()) {
            throw new BoxRuntimeException("Length is outside the query row range.");
        }
        if (length == 0) {
            length = query.size() - offset;
        }
        Query slicedQuery = new Query();
        query.getColumns().entrySet().stream().forEach(e -> slicedQuery.addColumn((Key)e.getKey(), ((QueryColumn)e.getValue()).getType()));
        for (int i = offset; i < query.size() && (length == 0 || i < offset + length); ++i) {
            slicedQuery.addRow(query.getRow(i));
        }
        return slicedQuery;
    }
}

