/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.string;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
@BoxMember(type=BoxLangType.STRING, name="Insert", objectArgument="string")
public class Insert
extends BIF {
    public Insert() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.substring), new Argument(true, "string", Key.string), new Argument(true, "integer", Key.position)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String substring = arguments.getAsString(Key.substring);
        String originalString = arguments.getAsString(Key.string);
        int position = arguments.getAsInteger(Key.position);
        if (substring == null || originalString == null) {
            throw new BoxRuntimeException("Both substring and originalString must be non-null");
        }
        if (position < 0 || position > originalString.length()) {
            throw new BoxRuntimeException("Position must be within the range [0, " + originalString.length() + "]");
        }
        StringBuilder result = new StringBuilder(originalString);
        result.insert(position, substring);
        return result.toString();
    }
}

