/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.string;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;

@BoxBIF
@BoxMember(type=BoxLangType.STRING, name="jsFormat")
public class JSStringFormat
extends BIF {
    public JSStringFormat() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.string)};
    }

    @Override
    public String _invoke(IBoxContext context, ArgumentsScope arguments) {
        String target = arguments.getAsString(Key.string);
        int len = target.length();
        StringBuilder result = new StringBuilder(len + 10);
        block10: for (int i = 0; i < len; ++i) {
            char c = target.charAt(i);
            switch (c) {
                case '\\': {
                    result.append("\\\\");
                    continue block10;
                }
                case '\n': {
                    result.append("\\n");
                    continue block10;
                }
                case '\r': {
                    result.append("\\r");
                    continue block10;
                }
                case '\f': {
                    result.append("\\f");
                    continue block10;
                }
                case '\b': {
                    result.append("\\b");
                    continue block10;
                }
                case '\t': {
                    result.append("\\t");
                    continue block10;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    result.append("\\'");
                    continue block10;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

