/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.string;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIFs(value={@BoxBIF(alias="LJustify"), @BoxBIF(alias="RJustify")})
@BoxMembers(value={@BoxMember(type=BoxLangType.STRING, name="LJustify"), @BoxMember(type=BoxLangType.STRING, name="RJustify")})
public class Justify
extends BIF {
    public Justify() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.string), new Argument(true, "integer", Key.length)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        StringBuilder justifiedString;
        Key bifMethodKey = arguments.getAsKey(BIF.__functionName);
        String input = arguments.getAsString(Key.string);
        int length = arguments.getAsInteger(Key.length);
        if (length <= 0) {
            throw new BoxRuntimeException("Length must be greater than 0");
        }
        int paddingCount = length - input.length();
        if (paddingCount <= 0) {
            return input;
        }
        if (bifMethodKey.equals(Key.lJustify)) {
            justifiedString = new StringBuilder(input);
        } else if (bifMethodKey.equals(Key.rJustify)) {
            justifiedString = new StringBuilder();
        } else {
            throw new BoxRuntimeException("Invalid BIF method key");
        }
        for (int i = 0; i < paddingCount; ++i) {
            justifiedString.append(" ");
        }
        if (bifMethodKey.equals(Key.rJustify)) {
            justifiedString.append(input);
        }
        return justifiedString.toString();
    }
}

