/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.string;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
@BoxMember(type=BoxLangType.STRING, name="Left")
public class Left
extends BIF {
    public Left() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.string), new Argument(true, "integer", Key.count)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String input = arguments.getAsString(Key.string);
        int count = arguments.getAsInteger(Key.count);
        if (count == 0) {
            throw new BoxRuntimeException("Count cannot be zero");
        }
        if (count > 0) {
            if (count > input.length()) {
                count = input.length();
            }
            return input.substring(0, count);
        }
        int end = input.length() + count;
        if (end < 0) {
            return input;
        }
        return input.substring(0, end);
    }
}

