/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.string;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.util.RegexUtil;
import ortus.boxlang.runtime.validation.Validator;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="reFindNoCase")})
@BoxMembers(value={@BoxMember(type=BoxLangType.STRING, name="reFind", objectArgument="string"), @BoxMember(type=BoxLangType.STRING, name="reFindNoCase", objectArgument="string")})
public class ReFind
extends BIF {
    public ReFind() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.reg_expression), new Argument(true, "string", Key.string), new Argument(false, "integer", Key.start, 1), new Argument(false, "boolean", Key.returnSubExpressions, false), new Argument(false, "string", Key.scope, (Object)"one", Set.of(Validator.valueOneOf("one", "all")))};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String reg_expression = arguments.getAsString(Key.reg_expression);
        String string = arguments.getAsString(Key.string);
        Integer start = arguments.getAsInteger(Key.start);
        Boolean returnSubExpressions = arguments.getAsBoolean(Key.returnSubExpressions);
        String scope = arguments.getAsString(Key.scope).toLowerCase();
        boolean noCase = arguments.get(BIF.__functionName).equals(Key.reFindNoCase);
        reg_expression = RegexUtil.posixReplace(reg_expression, noCase);
        reg_expression = RegexUtil.replaceNonQuantiferCurlyBraces(reg_expression);
        if (start < 1) {
            start = 1;
        }
        Matcher matcher = Pattern.compile(reg_expression, noCase ? 2 : 0).matcher(string);
        if (start > 1) {
            matcher.region(start - 1, string.length());
        }
        Array result = new Array();
        while (matcher.find()) {
            int groupCount = matcher.groupCount();
            Array lenArray = Array.of(new Object[]{matcher.group().length()});
            Array matchArray = Array.of(new Object[]{matcher.group()});
            Array posArray = Array.of(new Object[]{matcher.start() + 1});
            for (int i = 1; i <= groupCount; ++i) {
                String targetGroup = matcher.group(i);
                if (targetGroup == null) {
                    lenArray.add((Object)0);
                    matchArray.add("");
                    posArray.add((Object)0);
                    continue;
                }
                lenArray.add((Object)matcher.group(i).length());
                matchArray.add(matcher.group(i));
                posArray.add((Object)(matcher.start(i) + 1));
            }
            result.add(Struct.of(new Object[]{Key.len, lenArray, Key.match, matchArray, Key.pos, posArray}));
            if (!scope.equals("one")) continue;
            break;
        }
        if (returnSubExpressions.booleanValue()) {
            if (result.isEmpty()) {
                if (scope.equals("all")) {
                    return Array.of(new Object[]{Struct.of(new Object[]{Key.len, Array.of(new Object[]{0}), Key.match, Array.of(new Object[]{""}), Key.pos, Array.of(new Object[]{0})})});
                }
                return Struct.of(new Object[]{Key.len, Array.of(new Object[]{0}), Key.match, Array.of(new Object[]{""}), Key.pos, Array.of(new Object[]{0})});
            }
            if (scope.equals("one")) {
                return result.get(0);
            }
            return result;
        }
        if (result.isEmpty()) {
            return 0;
        }
        if (scope.equals("one")) {
            return ((Struct)result.get(0)).getAsArray(Key.pos).get(0);
        }
        Array positions = new Array();
        for (int i = 0; i < result.size(); ++i) {
            positions.add(((Struct)result.get(i)).getAsArray(Key.pos).get(0));
        }
        return positions;
    }
}

