/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.string;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.util.RegexUtil;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="reMatchNoCase")})
@BoxMembers(value={@BoxMember(type=BoxLangType.STRING, name="reMatch", objectArgument="string"), @BoxMember(type=BoxLangType.STRING, name="reMatchNoCase", objectArgument="string")})
public class ReMatch
extends BIF {
    private static final Key reMatchNoCase = Key.of("reMatchNoCase");

    public ReMatch() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.reg_expression), new Argument(true, "string", Key.string)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Object reg_expression = arguments.getAsString(Key.reg_expression);
        String string = arguments.getAsString(Key.string);
        boolean noCase = arguments.get(BIF.__functionName).equals(reMatchNoCase);
        if (string == null) {
            return new Array();
        }
        if (noCase) {
            reg_expression = "(?i)" + (String)reg_expression;
        }
        reg_expression = RegexUtil.posixReplace((String)reg_expression, noCase);
        reg_expression = RegexUtil.replaceNonQuantiferCurlyBraces((String)reg_expression);
        Matcher matcher = Pattern.compile((String)reg_expression).matcher(string);
        Array result = new Array();
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }
}

