/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.string;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.util.RegexUtil;
import ortus.boxlang.runtime.validation.Validator;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="reReplaceNoCase")})
@BoxMembers(value={@BoxMember(type=BoxLangType.STRING, name="ReReplace"), @BoxMember(type=BoxLangType.STRING, name="ReReplaceNoCase")})
public class ReReplace
extends BIF {
    private static final Key reFindNoCase = Key.of("ReReplaceNoCase");

    public ReReplace() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.string), new Argument(true, "string", Key.regex), new Argument(true, "string", Key.substring), new Argument(true, "string", Key.scope, (Object)"one", Set.of(Validator.valueOneOf("one", "all")))};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String string = arguments.getAsString(Key.string);
        Object regex = arguments.getAsString(Key.regex);
        String substring = arguments.getAsString(Key.substring);
        String scope = arguments.getAsString(Key.scope).toLowerCase();
        boolean noCase = arguments.get(BIF.__functionName).equals(reFindNoCase);
        if (noCase) {
            regex = "(?i)" + (String)regex;
        }
        if (string == null) {
            string = "";
        }
        if (substring == null) {
            substring = "";
        }
        if (regex == null) {
            regex = "";
        }
        regex = RegexUtil.posixReplace((String)regex, noCase);
        regex = RegexUtil.replaceNonQuantiferCurlyBraces((String)regex);
        StringBuffer result = new StringBuffer();
        Matcher matcher = Pattern.compile((String)regex).matcher(string);
        boolean upperCase = false;
        boolean lowerCase = false;
        while (matcher.find()) {
            StringBuffer replacement = new StringBuffer(substring);
            for (int i = 0; i < replacement.length() - 1; ++i) {
                if (replacement.charAt(i) != '\\' || i > 0 && replacement.charAt(i - 1) == '\\') continue;
                if (replacement.charAt(i + 1) == 'U') {
                    upperCase = true;
                    lowerCase = false;
                    replacement.delete(i, i + 2);
                    --i;
                    continue;
                }
                if (replacement.charAt(i + 1) == 'L') {
                    lowerCase = true;
                    upperCase = false;
                    replacement.delete(i, i + 2);
                    --i;
                    continue;
                }
                if (replacement.charAt(i + 1) == 'E') {
                    upperCase = false;
                    lowerCase = false;
                    replacement.delete(i, i + 2);
                    --i;
                    continue;
                }
                if (!Character.isDigit(replacement.charAt(i + 1))) continue;
                int groupIndex = Character.getNumericValue(replacement.charAt(i + 1));
                Object group = matcher.group(groupIndex);
                if (upperCase && group != null) {
                    group = ((String)group).toUpperCase();
                } else if (lowerCase && group != null) {
                    group = ((String)group).toLowerCase();
                }
                if (i >= 2 && replacement.charAt(i - 2) == '\\' && group != null) {
                    if (replacement.charAt(i - 1) == 'u') {
                        group = Character.toUpperCase(((String)group).charAt(0)) + ((String)group).substring(1);
                        replacement.delete(i - 2, i);
                        i -= 2;
                    } else if (replacement.charAt(i - 1) == 'l') {
                        group = Character.toLowerCase(((String)group).charAt(0)) + ((String)group).substring(1);
                        replacement.delete(i - 2, i);
                        i -= 2;
                    }
                }
                replacement.replace(i, i + 2, (String)group);
                i += (group != null ? ((String)group).length() : 0) - 2;
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement.toString()));
            if (!scope.equals("one")) continue;
            break;
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

