/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.string;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
public class RepeatString
extends BIF {
    public RepeatString() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.string), new Argument(true, "integer", Key.count)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String input = arguments.getAsString(Key.string);
        int count = arguments.getAsInteger(Key.count);
        if (count < 0) {
            throw new BoxRuntimeException("Count must be a non-negative number");
        }
        if (count == 0) {
            return "";
        }
        StringBuilder repeatedString = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            repeatedString.append(input);
        }
        return repeatedString.toString();
    }
}

