/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.string;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;

@BoxBIF
@BoxMember(type=BoxLangType.STRING, name="UCFirst")
public class UCFirst
extends BIF {
    public UCFirst() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.string), new Argument(false, "boolean", Key.doAll, false), new Argument(false, "boolean", Key.doLowerIfAllUppercase, false)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String input = arguments.getAsString(Key.string);
        boolean doAll = arguments.getAsBoolean(Key.doAll);
        boolean doLowerIfAllUppercase = arguments.getAsBoolean(Key.doLowerIfAllUppercase);
        if (input.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        String[] words = input.split("\\s+");
        for (int i = 0; i < words.length; ++i) {
            Object word = words[i];
            if (doLowerIfAllUppercase && ((String)word).toUpperCase().equals(word)) {
                word = ((String)word).toLowerCase();
            }
            if (doAll || i == 0) {
                char firstChar = ((String)word).charAt(0);
                char upperFirstChar = Character.toUpperCase(firstChar);
                word = upperFirstChar + ((String)word).substring(1);
            }
            result.append((String)word);
            if (i >= words.length - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }
}

