/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.string;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;

@BoxBIF
@BoxMember(type=BoxLangType.STRING, name="Wrap")
public class Wrap
extends BIF {
    public Wrap() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.string), new Argument(true, "integer", Key.limit), new Argument(false, "boolean", Key.strip, false)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String input = arguments.getAsString(Key.string);
        int limit = arguments.getAsInteger(Key.limit);
        boolean strip = arguments.getAsBoolean(Key.strip);
        if (strip) {
            input = input.replaceAll("\\r?\\n", " ");
        }
        return this.wrapText(input, limit);
    }

    private String wrapText(String text, int limit) {
        if (text == null) {
            return "";
        }
        StringBuilder wrapped = new StringBuilder();
        int index = 0;
        while (index < text.length()) {
            if (index + limit > text.length()) {
                wrapped.append(text, index, text.length());
                break;
            }
            int spaceToWrapAt = text.lastIndexOf(32, index + limit);
            if (spaceToWrapAt <= index) {
                wrapped.append(text, index, index + limit).append(System.lineSeparator());
                index += limit;
                continue;
            }
            wrapped.append(text, index, spaceToWrapAt).append(System.lineSeparator());
            index = spaceToWrapAt + 1;
        }
        return wrapped.toString();
    }
}

