/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.struct;

import java.util.Comparator;
import java.util.HashMap;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.FunctionCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.util.StructUtil;
import ortus.boxlang.runtime.util.LocalizationUtil;

@BoxBIF
public class StructNew
extends BIF {
    public StructNew() {
        this.declaredArguments = new Argument[]{new Argument(false, "string", Key.type, "default"), new Argument(false, "any", Key.sortType), new Argument(false, "string", Key.sortOrder, "asc"), new Argument(false, "any", Key.localeSensitive, false), new Argument(false, "function:Comparator", Key.callback)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        HashMap<Key, Comparator<Key>> commonComparators;
        IStruct.TYPES type = IStruct.TYPES.fromString(arguments.getAsString(Key.type));
        CastAttempt<Function> typeCastToFunctionAttempt = FunctionCaster.attempt(arguments.get(Key.sortType), "Comparator");
        if (typeCastToFunctionAttempt.wasSuccessful()) {
            arguments.put(Key.callback, (Object)typeCastToFunctionAttempt.get());
            arguments.put(Key.sortType, (Object)null);
        }
        Comparator<Key> comparator = null;
        String sort = arguments.getAsString(Key.sortType);
        HashMap<Key, Comparator<Key>> hashMap = commonComparators = arguments.getAsBoolean(Key.localeSensitive) != false ? StructUtil.getCommonComparators(LocalizationUtil.parseLocaleFromContext(context, arguments)) : StructUtil.getCommonComparators();
        if (sort != null) {
            Key sortKey = Key.of(sort + arguments.getAsString(Key.sortOrder));
            if (sort.toLowerCase().contains("nocase") && type.equals((Object)IStruct.TYPES.LINKED_CASE_SENSITIVE)) {
                throw new BoxRuntimeException(String.format("Invalid sort type [%s]. A case-sensitive struct can not be ordered without case consideration.", sort));
            }
            type = IStruct.TYPES.SORTED;
            comparator = commonComparators.get(sortKey);
        } else if (arguments.getAsFunction(Key.callback) != null) {
            type = IStruct.TYPES.SORTED;
            comparator = (a, b) -> (Integer)context.invokeFunction((Object)arguments.getAsFunction(Key.callback), new Object[]{a.getName(), b.getName()});
        }
        return comparator == null ? new Struct(type) : new Struct(comparator);
    }
}

