/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.system;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.events.InterceptorPool;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.interop.proxies.IInterceptorLambda;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
public class BoxRegisterInterceptor
extends BIF {
    protected InterceptorPool interceptorTarget;

    public BoxRegisterInterceptor() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.interceptor), new Argument(false, "any", Key.states, new Array())};
        this.interceptorTarget = this.interceptorService;
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Object interceptor = arguments.get(Key.interceptor);
        Key[] states = BoxRegisterInterceptor.inflateStates(arguments.get(Key.states));
        if (interceptor instanceof IClassRunnable) {
            IClassRunnable boxClass = (IClassRunnable)interceptor;
            this.interceptorTarget.registerInterceptionPoint(states).register(boxClass);
        }
        if (interceptor instanceof DynamicObject) {
            DynamicObject boxObject = (DynamicObject)interceptor;
            this.interceptorTarget.register(boxObject, states);
        }
        if (interceptor instanceof Function) {
            Function castedFunction = (Function)interceptor;
            if (states.length == 0) {
                throw new BoxRuntimeException("Closures/Lambdas need at least one state to listen to");
            }
            this.interceptorTarget.register(new IInterceptorLambda(castedFunction, context, null), states);
        }
        return true;
    }

    public static Key[] inflateStates(Object states) {
        if (states instanceof String) {
            String castedString = (String)states;
            states = Array.fromString(castedString);
        }
        if (states instanceof Array) {
            Array castedArray = (Array)states;
            return (Key[])castedArray.stream().map(Key::of).toArray(Key[]::new);
        }
        return new Key[0];
    }
}

