/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.system;

import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
public class CreateObject
extends BIF {
    private static final ClassLocator CLASS_LOCATOR = BoxRuntime.getInstance().getClassLocator();
    private static final String CLASS_TYPE = "class";
    private static final String COMPONENT_TYPE = "component";

    public CreateObject() {
        this.declaredArguments = new Argument[]{new Argument(false, "string", Key.type, CLASS_TYPE), new Argument(false, "string", Key.className)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String type = arguments.getAsString(Key.type);
        String className = arguments.getAsString(Key.className);
        if (className == null) {
            className = type;
            type = CLASS_TYPE;
        }
        if (type.equalsIgnoreCase("java")) {
            return CLASS_LOCATOR.load(context, className, "java", true, context.getCurrentImports());
        }
        if (type.equalsIgnoreCase(COMPONENT_TYPE) || type.equalsIgnoreCase(CLASS_TYPE)) {
            DynamicObject result = CLASS_LOCATOR.load(context, className, "bx", true, context.getCurrentImports());
            if (IClassRunnable.class.isAssignableFrom(result.getTargetClass())) {
                return result.invokeConstructor(context, Key.noInit).unWrapBoxLangClass();
            }
            return result.unWrapBoxLangClass();
        }
        IStruct interceptorArgs = Struct.of(new Object[]{Key.response, null, Key.context, context, Key.arguments, arguments});
        this.interceptorService.announce(BoxEvent.ON_CREATEOBJECT_REQUEST, interceptorArgs);
        if (interceptorArgs.get(Key.response) != null) {
            return interceptorArgs.get(Key.response);
        }
        throw new BoxRuntimeException("Unsupported type: " + arguments.getAsString(Key.type));
    }
}

