/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.system;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;
import ortus.boxlang.runtime.validation.Validator;

@BoxBIF
public class GetBaseTagData
extends BIF {
    public GetBaseTagData() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.tagName, Set.of(Validator.NON_EMPTY)), new Argument(true, "integer", Key.ancestorLevels, (Object)1, Set.of(Validator.min(1)))};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String tagName = arguments.getAsString(Key.tagName);
        Integer ancestorLevels = arguments.getAsInteger(Key.ancestorLevels);
        if (tagName.contains("_")) {
            tagName = tagName.substring(tagName.indexOf("_") + 1);
        }
        Key tagKey = Key.of(tagName);
        List<IStruct> components = Arrays.asList(context.getComponents()).stream().filter(s -> s.get(Key._NAME).equals(Key.module) && s.get(Key.customTagName).equals(tagKey)).toList();
        if (components.isEmpty()) {
            throw new BoxValidationException(tagName + " not found");
        }
        if (ancestorLevels > components.size()) {
            throw new BoxValidationException("ancestorLevels is greater than the number of ancestor tags");
        }
        IStruct component = components.get(ancestorLevels - 1);
        return Struct.of(new Object[]{Key.caller, component.get(Key.caller), Key.thisTag, component.get(Key.thisTag), Key.attributes, component.getAsStruct(Key.attributes).get(Key.attributes)});
    }
}

