/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.system;

import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.interop.DynamicInteropService;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.runnables.BoxInterface;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;

@BoxBIF
public class GetClassMetadata
extends BIF {
    private static final ClassLocator CLASS_LOCATOR = BoxRuntime.getInstance().getClassLocator();

    public GetClassMetadata() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.path)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Object path = arguments.get(Key.path);
        if (path instanceof IClassRunnable) {
            IClassRunnable castedObject = (IClassRunnable)path;
            return castedObject.getBoxMeta().getMeta();
        }
        DynamicObject loadedClass = CLASS_LOCATOR.load(context, (String)path, "bx", true, context.getCurrentImports());
        if (DynamicInteropService.isInterface(loadedClass.getTargetClass())) {
            BoxInterface boxInterface = (BoxInterface)loadedClass.unWrapBoxLangClass();
            return boxInterface.getMetaData();
        }
        loadedClass.invokeConstructor(context, Key.noInit);
        IClassRunnable boxClass = (IClassRunnable)loadedClass.unWrapBoxLangClass();
        return boxClass.getBoxMeta().getMeta();
    }
}

