/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.system;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
public class GetSystemSetting
extends BIF {
    public GetSystemSetting() {
        this.declaredArguments = new Argument[]{new Argument(true, "String", Key.key), new Argument(false, "String", Key.defaultValue)};
    }

    @Override
    public String _invoke(IBoxContext context, ArgumentsScope arguments) {
        Key key = Key.of(arguments.getAsString(Key.key));
        String defaultValue = arguments.getAsString(Key.defaultValue);
        IStruct system = context.getScope(Key.server).getAsStruct(Key.system);
        IStruct environment = system.getAsStruct(Key.environment);
        IStruct properties = system.getAsStruct(Key.properties);
        String value = properties.getAsString(key);
        if (value != null) {
            return value;
        }
        value = environment.getAsString(key);
        if (value != null) {
            return value;
        }
        if (defaultValue == null) {
            throw new BoxRuntimeException("System property or environment variable not found: " + String.valueOf(key));
        }
        return defaultValue;
    }
}

