/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.system;

import java.util.Map;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;

@BoxBIF
public class Invoke
extends BIF {
    ClassLocator classLocator = BoxRuntime.getInstance().getClassLocator();

    public Invoke() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.instance), new Argument(true, "string", Key.methodname), new Argument(false, "any", Key.arguments)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        IReferenceable actualInstance;
        CastAttempt<String> stringCasterAttempt;
        Object instance = arguments.get(Key.instance);
        Key methodname = Key.of(arguments.getAsString(Key.methodname));
        Object args = arguments.get(Key.arguments);
        IStruct argCollection = Struct.of(new Object[0]);
        if (args != null) {
            argCollection.put(Key.argumentCollection, args);
        }
        if ((stringCasterAttempt = StringCaster.attempt(instance)).wasSuccessful() && stringCasterAttempt.get().isEmpty()) {
            return context.invokeFunction(methodname, (Map<Key, Object>)argCollection);
        }
        if (stringCasterAttempt.wasSuccessful()) {
            actualInstance = (IClassRunnable)this.classLocator.load(context, "bx:" + stringCasterAttempt.get(), context.getCurrentImports()).invokeConstructor(context, Key.noInit).unWrapBoxLangClass();
        } else if (instance instanceof IReferenceable) {
            IReferenceable cvs;
            actualInstance = cvs = (IReferenceable)instance;
        } else {
            throw new BoxValidationException("The instance parameter must be a Box Class, referencable struct or the name of a Box Class to instantiate.");
        }
        return actualInstance.dereferenceAndInvoke(context, methodname, argCollection, (Boolean)false);
    }
}

