/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.system;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.conversion.ObjectMarshaller;

@BoxBIF
public class ObjectSerialize
extends BIF {
    public ObjectSerialize() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.object), new Argument(false, "string", Key.file)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Object target = arguments.get(Key.object);
        if (target == null) {
            throw new BoxRuntimeException("The object to serialize is null");
        }
        byte[] serializedData = ObjectMarshaller.serialize(context, target);
        Object filePath = arguments.get(Key.file);
        if (filePath != null) {
            context.invokeFunction(Key.of("FileWrite"), new Object[]{(String)filePath, serializedData});
        }
        return serializedData;
    }
}

