/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.system;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.ScriptingRequestBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxValidationException;

@BoxBIF
public class RunThreadInContext
extends BIF {
    public RunThreadInContext() {
        this.declaredArguments = new Argument[]{new Argument(false, "string", Key.applicationName), new Argument(false, "string", Key.sessionId), new Argument(false, "any", Key.context), new Argument(true, "function", Key.callback)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Function callback = arguments.getAsFunction(Key.callback);
        String applicationName = arguments.getAsString(Key.applicationName);
        String sessionId = arguments.getAsString(Key.sessionId);
        Object objContext = arguments.get(Key.context);
        IBoxContext newContext = null;
        if (objContext != null) {
            IBoxContext ctx;
            if (!(objContext instanceof IBoxContext)) {
                throw new BoxValidationException("Context must be instance of IBoxContext.");
            }
            newContext = ctx = (IBoxContext)objContext;
            if (applicationName != null || sessionId != null) {
                throw new BoxValidationException("Context and applicationName/sessionId are mutually exclusive.");
            }
        } else if (applicationName != null) {
            ScriptingRequestBoxContext scriptingRequestContext = new ScriptingRequestBoxContext(this.runtime.getRuntimeContext());
            newContext = scriptingRequestContext;
            IStruct appSettings = Struct.of(new Object[]{Key._NAME, applicationName});
            if (sessionId != null) {
                scriptingRequestContext.setSessionID(Key.of(sessionId));
                appSettings.put(Key.sessionManagement, (Object)true);
            }
            scriptingRequestContext.getApplicationListener().updateSettings(appSettings);
        } else {
            throw new BoxValidationException("Context or applicationName is required.");
        }
        newContext.invokeFunction(callback);
        return null;
    }
}

