/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.system;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
public class SystemExecute
extends BIF {
    public SystemExecute() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.of("name")), new Argument(false, "any", Key.arguments), new Argument(false, "long", Key.timeout), new Argument(false, "boolean", Key.terminateOnTimeout, false), new Argument(false, "string", Key.directory), new Argument(false, "string", Key.output), new Argument(false, "string", Key.error)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String bin = arguments.getAsString(Key.of("name"));
        Object args = arguments.get(Key.arguments);
        String directory = arguments.getAsString(Key.directory);
        Long timeout = arguments.getAsLong(Key.timeout);
        Boolean terminateOnTimeout = arguments.getAsBoolean(Key.terminateOnTimeout);
        String outputTarget = arguments.getAsString(Key.output);
        String errorTarget = arguments.getAsString(Key.error);
        ArrayList<String> cmd = new ArrayList<String>(1);
        Struct response = new Struct((Map<? extends Object, ? extends Object>)new HashMap<Key, Object>(){
            {
                this.put(Key.output, null);
                this.put(Key.error, null);
                this.put(Key.timeout, false);
                this.put(Key.terminated, false);
                this.put(Key.pid, null);
            }
        });
        cmd.add(bin);
        if (args instanceof String) {
            Matcher matches = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'").matcher(StringCaster.cast(args));
            matches.reset();
            while (matches.find()) {
                cmd.add(matches.group());
            }
        } else if (args instanceof Array) {
            ArrayCaster.cast(args).stream().forEach(arg -> cmd.add(StringCaster.cast(arg)));
        } else {
            throw new BoxRuntimeException(String.format("The provided process arguments provided [%s] could not be parsed in to command arguments", args.toString()));
        }
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        if (directory != null) {
            processBuilder.directory(Path.of(directory, new String[0]).toFile());
        }
        if (outputTarget != null) {
            processBuilder.redirectOutput(Path.of(outputTarget, new String[0]).toFile());
        }
        if (errorTarget != null) {
            processBuilder.redirectError(Path.of(errorTarget, new String[0]).toFile());
        }
        Process process = null;
        try {
            process = processBuilder.start();
            response.put(Key.pid, (Object)process.pid());
            if (timeout != null && timeout != 0L) {
                process.waitFor(timeout, TimeUnit.SECONDS);
                response.put(Key.timeout, (Object)true);
                if (terminateOnTimeout.booleanValue() && process.isAlive()) {
                    process.destroy();
                    response.put(Key.terminated, (Object)true);
                }
            } else {
                process.waitFor();
            }
            if (!response.getAsBoolean(Key.terminated).booleanValue()) {
                if (process != null && outputTarget == null && process.getInputStream() != null) {
                    response.put(Key.output, (Object)process.inputReader().lines().collect(Collectors.joining("\n")));
                }
                if (process != null && errorTarget == null && process.getErrorStream() != null) {
                    response.put(Key.error, (Object)process.errorReader().lines().collect(Collectors.joining("\n")));
                }
            }
            return response;
        }
        catch (IOException e) {
            throw new BoxRuntimeException(String.format("An exception occurred while attempting to execute the statement [%s]", StringUtils.join(cmd, " ")), e);
        }
        catch (InterruptedException ie) {
            throw new BoxRuntimeException("An error occurred while attempting to wait for process completion", ie);
        }
    }
}

