/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.system;

import java.io.PrintStream;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.IType;

@BoxBIF
public class SystemOutput
extends BIF {
    private static final Key addNewLineKey = Key.of("addNewLine");
    private static final Key doErrorStreamKey = Key.of("doErrorStream");

    public SystemOutput() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.obj), new Argument(true, "boolean", addNewLineKey, false), new Argument(false, "boolean", doErrorStreamKey, false)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        RequestBoxContext rCon;
        Object obj = arguments.get(Key.obj);
        Boolean addNewLine = arguments.getAsBoolean(addNewLineKey);
        Boolean doErrorStream = arguments.getAsBoolean(doErrorStreamKey);
        if (obj instanceof IType) {
            IType t = (IType)obj;
            obj = t.asString();
        }
        PrintStream stream = (rCon = context.getParentOfType(RequestBoxContext.class)) != null ? rCon.getOut() : System.out;
        if (doErrorStream.booleanValue()) {
            stream = System.err;
        }
        if (addNewLine.booleanValue()) {
            stream.println(obj);
        } else {
            stream.print(obj);
        }
        return null;
    }
}

