/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.system;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
public class URLDecode
extends BIF {
    public URLDecode() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.string), new Argument(false, "string", Key.charset, "UTF-8")};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        String str = arguments.getAsString(Key.string);
        String charset = arguments.getAsString(Key.charset);
        try {
            return URLDecoder.decode(str, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new BoxRuntimeException("Error URL decoding string", e);
        }
    }
}

