/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.temporal;

import java.time.DayOfWeek;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.DateTimeCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.LocalizationUtil;

@BoxBIF
@BoxMember(type=BoxLangType.DATETIME, name="diff", objectArgument="date1")
public class DateDiff
extends BIF {
    private static final long IMPROBABLE_RESULT = -999999999999L;

    public DateDiff() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.datepart), new Argument(true, "any", Key.date1), new Argument(true, "any", Key.date2)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Key datePart = Key.of(arguments.getAsString(Key.datepart));
        ZoneId timezone = LocalizationUtil.parseZoneId(null, context);
        DateTime date1 = DateTimeCaster.cast(arguments.get(Key.date1), true, timezone);
        DateTime date2 = DateTimeCaster.cast(arguments.get(Key.date2), true, timezone);
        long result = -999999999999L;
        long l = datePart.equals(parts.years) ? ChronoUnit.YEARS.between(date1.getWrapped(), date2.getWrapped()) : (datePart.equals(parts.quarters) ? ChronoUnit.MONTHS.between(date1.getWrapped(), date2.getWrapped()) / 3L : (datePart.equals(parts.months) ? ChronoUnit.MONTHS.between(date1.getWrapped(), date2.getWrapped()) : (datePart.equals(parts.days) || datePart.equals(parts.daysAlt) ? ChronoUnit.DAYS.between(date1.getWrapped(), date2.getWrapped()) : (datePart.equals(parts.weeks) || datePart.equals(parts.weeksAlt) ? ChronoUnit.WEEKS.between(date1.getWrapped(), date2.getWrapped()) : (datePart.equals(parts.weekDays) ? DateDiff.getWeekDaysBetween(date1.getWrapped(), date2.getWrapped()) : (datePart.equals(parts.hours) ? ChronoUnit.HOURS.between(date1.getWrapped(), date2.getWrapped()) : (datePart.equals(parts.minutes) ? ChronoUnit.MINUTES.between(date1.getWrapped(), date2.getWrapped()) : (datePart.equals(parts.seconds) ? ChronoUnit.SECONDS.between(date1.getWrapped(), date2.getWrapped()) : (result = datePart.equals(parts.milliseconds) ? ChronoUnit.MILLIS.between(date1.getWrapped(), date2.getWrapped()) : result)))))))));
        if (result == -999999999999L) {
            throw new BoxRuntimeException(String.format("The datepart [%s] is not supported for the method DateDiff or the member function Date.diff", datePart.getName()));
        }
        return result;
    }

    public static Long getWeekDaysBetween(ZonedDateTime date1, ZonedDateTime date2) {
        DayOfWeek date1DOW = date1.getDayOfWeek();
        DayOfWeek date2DOW = date2.getDayOfWeek();
        long days = ChronoUnit.DAYS.between(date1, date2);
        long daysWithoutWeekends = days - 2L * ((days + (long)date1DOW.getValue()) / 7L);
        return daysWithoutWeekends + (long)(date1DOW.equals(DayOfWeek.SUNDAY) ? 1 : 0) + (long)(date2DOW.equals(DayOfWeek.SUNDAY) ? 1 : 0);
    }

    private static final class parts {
        private static final Key years = Key.of("yyyy");
        private static final Key quarters = Key.of("q");
        private static final Key months = Key.of("m");
        private static final Key days = Key.of("d");
        private static final Key daysAlt = Key.of("y");
        private static final Key weeks = Key.of("w");
        private static final Key weeksAlt = Key.of("ww");
        private static final Key weekDays = Key.of("wd");
        private static final Key hours = Key.of("h");
        private static final Key minutes = Key.of("n");
        private static final Key seconds = Key.of("s");
        private static final Key milliseconds = Key.of("l");

        private parts() {
        }
    }
}

