/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.temporal;

import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.global.temporal.TimeUnits;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
public class DatePart
extends TimeUnits {
    private static final Struct parts = new Struct((Map<? extends Object, ? extends Object>)new HashMap<String, Object>(){
        {
            this.put("d", TimeUnits.BIFMethods.day);
            this.put("yyyy", Key.of("Year"));
            this.put("q", TimeUnits.BIFMethods.quarter);
            this.put("m", TimeUnits.BIFMethods.month);
            this.put("y", Key.of("DayOfYear"));
            this.put("w", TimeUnits.BIFMethods.dayOfWeek);
            this.put("ww", TimeUnits.BIFMethods.week);
            this.put("h", Key.of("Hour"));
            this.put("n", Key.of("Minute"));
            this.put("s", Key.of("Second"));
            this.put("l", TimeUnits.BIFMethods.millis);
        }
    });

    public DatePart() {
        this.declaredArguments = new Argument[]{new Argument(true, "string", Key.datepart), new Argument(true, "any", Key.date), new Argument(false, "string", Key.timezone)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Key datePart = Key.of(arguments.getAsString(Key.datepart));
        if (!parts.containsKey(datePart)) {
            throw new BoxRuntimeException(String.format("The key [%s] is not supported for the DatePart method", datePart));
        }
        arguments.put(BIF.__functionName, parts.get(datePart));
        return super._invoke(context, arguments);
    }
}

