/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.temporal;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.DateTimeCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.util.LocalizationUtil;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="DateFormat"), @BoxBIF(alias="TimeFormat")})
@BoxMembers(value={@BoxMember(type=BoxLangType.DATETIME, name="format"), @BoxMember(type=BoxLangType.DATETIME, name="dateFormat"), @BoxMember(type=BoxLangType.DATETIME, name="timeFormat"), @BoxMember(type=BoxLangType.DATETIME, name="dateTimeFormat"), @BoxMember(type=BoxLangType.STRING, name="dateFormat"), @BoxMember(type=BoxLangType.STRING, name="timeFormat"), @BoxMember(type=BoxLangType.STRING, name="dateTimeFormat")})
public class DateTimeFormat
extends BIF {
    private static final Key FORMAT_EPOCH = Key.of("epoch");
    private static final Key FORMAT_EPOCHMS = Key.of("epochms");

    public DateTimeFormat() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.date), new Argument(false, "string", Key.mask), new Argument(false, "string", Key.timezone), new Argument(false, "string", Key.locale)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        ZoneId timezone = LocalizationUtil.parseZoneId(arguments.getAsString(Key.timezone), context);
        DateTime ref = DateTimeCaster.cast(arguments.get(Key.date), true, timezone);
        Key bifMethodKey = arguments.getAsKey(BIF.__functionName);
        String format = arguments.getAsString(Key.mask);
        if (format == null) {
            format = arguments.getAsString(Key.format);
        }
        Locale locale = LocalizationUtil.parseLocaleFromContext(context, arguments);
        ref = new DateTime(ref.getWrapped().withZoneSameInstant(timezone));
        if (format == null && bifMethodKey.equals(Key.dateFormat)) {
            return locale == null ? ref.format("dd-MMM-yy") : ref.format(locale, "dd-MMM-yy");
        }
        if (format == null && bifMethodKey.equals(Key.timeFormat)) {
            return locale == null ? ref.format("hh:mm a") : ref.format(locale, "hh:mm a");
        }
        if (format == null) {
            return locale == null ? ref.format("dd-MMM-yyyy HH:mm:ss") : ref.format(locale, "dd-MMM-yyyy HH:mm:ss");
        }
        Key formatKey = Key.of(format);
        String mode = bifMethodKey.equals(Key.dateFormat) ? "Date" : (bifMethodKey.equals(Key.timeFormat) ? "Time" : "DateTime");
        Key commonFormatKey = Key.of(format.trim() + mode);
        if (formatKey.equals(FORMAT_EPOCH)) {
            return ref.toEpoch();
        }
        if (formatKey.equals(FORMAT_EPOCHMS)) {
            return ref.toEpochMillis();
        }
        if (DateTime.COMMON_FORMATTERS.containsKey(commonFormatKey)) {
            DateTimeFormatter formatter = (DateTimeFormatter)DateTime.COMMON_FORMATTERS.get(commonFormatKey);
            return locale == null ? ref.format(formatter) : ref.format(formatter.withLocale(locale));
        }
        return locale == null ? ref.format(format) : ref.format(locale, format);
    }
}

