/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.temporal;

import java.time.ZoneId;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.unmodifiable.UnmodifiableStruct;
import ortus.boxlang.runtime.util.LocalizationUtil;

@BoxBIF
public class GetTimezoneInfo
extends BIF {
    public GetTimezoneInfo() {
        this.declaredArguments = new Argument[]{new Argument(false, "string", Key.timezone), new Argument(false, "string", Key.locale)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        ZoneId zone = LocalizationUtil.parseZoneId(arguments.getAsString(Key.timezone), context);
        TimeZone tz = TimeZone.getTimeZone(zone);
        Locale locale = LocalizationUtil.parseLocale(arguments.getAsString(Key.locale));
        if (locale == null) {
            locale = Locale.getDefault();
        }
        int hourOffset = tz.getRawOffset() / 3600000;
        int minuteOffset = tz.getRawOffset() / 60000 - hourOffset * 60;
        return UnmodifiableStruct.of("DSTOffset", tz.getDSTSavings(), "id", tz.getID(), "isDSTon", tz.inDaylightTime(new Date()), "name", tz.getDisplayName(false, 1, locale), "nameDST", tz.getDisplayName(true, 1, locale), "offset", tz.getRawOffset() / 1000, "shortName", tz.getDisplayName(false, 0, locale), "shortNameDST", tz.getDisplayName(true, 0, locale), "timezone", tz.getID(), "utcHourOffset", hourOffset, "utcMinuteOffset", minuteOffset, "utcTotalOffset", Math.abs(tz.getRawOffset() / 1000));
    }
}

