/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.temporal;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.DateTimeCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.util.LocalizationUtil;

@BoxBIF
@BoxMembers(value={@BoxMember(type=BoxLangType.STRING, name="parseDateTime"), @BoxMember(type=BoxLangType.STRING, name="toDateTime")})
public class ParseDateTime
extends BIF {
    public ParseDateTime() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.date), new Argument(false, "string", Key.format), new Argument(false, "string", Key.timezone), new Argument(false, "string", Key.locale)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Object dateRef = arguments.get(Key.date);
        String format = arguments.getAsString(Key.format);
        ZoneId timezone = LocalizationUtil.parseZoneId(arguments.getAsString(Key.timezone), context);
        Locale locale = LocalizationUtil.parseLocale(arguments.getAsString(Key.locale));
        if (dateRef instanceof DateTime) {
            DateTime dateObj = DateTimeCaster.cast(dateRef);
            if (format != null) {
                dateObj.setFormat(format);
            } else if (locale != null) {
                dateObj.setFormat(DateTimeFormatter.ISO_LOCAL_DATE_TIME.withLocale(locale));
            }
            return dateObj;
        }
        if (format != null) {
            return new DateTime(StringCaster.cast(dateRef), format, timezone);
        }
        if (locale != null) {
            return new DateTime(StringCaster.cast(dateRef), locale, timezone);
        }
        return new DateTime(StringCaster.cast(dateRef), timezone);
    }
}

