/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.temporal;

import java.time.Year;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.WeekFields;
import java.util.Locale;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.DateTimeCaster;
import ortus.boxlang.runtime.dynamic.casters.LongCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.LocalizationUtil;

@BoxBIFs(value={@BoxBIF(alias="Year"), @BoxBIF(alias="Quarter"), @BoxBIF(alias="Month"), @BoxBIF(alias="MonthAsString"), @BoxBIF(alias="MonthShortAsString"), @BoxBIF(alias="Day"), @BoxBIF(alias="DayOfWeek"), @BoxBIF(alias="DayOfWeekAsString"), @BoxBIF(alias="DayOfWeekShortAsString"), @BoxBIF(alias="DaysInMonth"), @BoxBIF(alias="DaysInYear"), @BoxBIF(alias="DayOfYear"), @BoxBIF(alias="FirstDayOfMonth"), @BoxBIF(alias="Week"), @BoxBIF(alias="Hour"), @BoxBIF(alias="Minute"), @BoxBIF(alias="Second"), @BoxBIF(alias="Millisecond"), @BoxBIF(alias="Nanosecond"), @BoxBIF(alias="Offset"), @BoxBIF(alias="GetTimezone"), @BoxBIF(alias="GetNumericDate"), @BoxBIF(alias="GetTime")})
@BoxMembers(value={@BoxMember(type=BoxLangType.DATETIME, name="year"), @BoxMember(type=BoxLangType.DATETIME, name="quarter"), @BoxMember(type=BoxLangType.DATETIME, name="month"), @BoxMember(type=BoxLangType.DATETIME, name="monthAsString"), @BoxMember(type=BoxLangType.DATETIME, name="monthShortAsString"), @BoxMember(type=BoxLangType.DATETIME, name="day"), @BoxMember(type=BoxLangType.DATETIME, name="dayOfWeek"), @BoxMember(type=BoxLangType.DATETIME, name="dayOfWeekAsString"), @BoxMember(type=BoxLangType.DATETIME, name="dayOfWeekShortAsString"), @BoxMember(type=BoxLangType.DATETIME, name="daysInMonth"), @BoxMember(type=BoxLangType.DATETIME, name="daysInYear"), @BoxMember(type=BoxLangType.DATETIME, name="dayOfYear"), @BoxMember(type=BoxLangType.DATETIME, name="firstDayOfMonth"), @BoxMember(type=BoxLangType.DATETIME, name="week"), @BoxMember(type=BoxLangType.DATETIME, name="hour"), @BoxMember(type=BoxLangType.DATETIME, name="minute"), @BoxMember(type=BoxLangType.DATETIME, name="second"), @BoxMember(type=BoxLangType.DATETIME, name="millisecond"), @BoxMember(type=BoxLangType.DATETIME, name="nanosecond"), @BoxMember(type=BoxLangType.DATETIME, name="offset"), @BoxMember(type=BoxLangType.DATETIME, name="timezone"), @BoxMember(type=BoxLangType.DATETIME, name="getnumericdate"), @BoxMember(type=BoxLangType.DATETIME, name="getTime"), @BoxMember(type=BoxLangType.STRING, name="year"), @BoxMember(type=BoxLangType.STRING, name="quarter"), @BoxMember(type=BoxLangType.STRING, name="month"), @BoxMember(type=BoxLangType.STRING, name="monthAsString"), @BoxMember(type=BoxLangType.STRING, name="monthShortAsString"), @BoxMember(type=BoxLangType.STRING, name="day"), @BoxMember(type=BoxLangType.STRING, name="dayOfWeek"), @BoxMember(type=BoxLangType.STRING, name="dayOfWeekAsString"), @BoxMember(type=BoxLangType.STRING, name="dayOfWeekShortAsString"), @BoxMember(type=BoxLangType.STRING, name="daysInMonth"), @BoxMember(type=BoxLangType.STRING, name="daysInYear"), @BoxMember(type=BoxLangType.STRING, name="dayOfYear"), @BoxMember(type=BoxLangType.STRING, name="firstDayOfMonth"), @BoxMember(type=BoxLangType.STRING, name="week"), @BoxMember(type=BoxLangType.STRING, name="hour"), @BoxMember(type=BoxLangType.STRING, name="minute"), @BoxMember(type=BoxLangType.STRING, name="second"), @BoxMember(type=BoxLangType.STRING, name="millisecond"), @BoxMember(type=BoxLangType.STRING, name="nanosecond"), @BoxMember(type=BoxLangType.STRING, name="offset"), @BoxMember(type=BoxLangType.STRING, name="timezone"), @BoxMember(type=BoxLangType.STRING, name="getnumericdate"), @BoxMember(type=BoxLangType.STRING, name="getTime")})
public class TimeUnits
extends BIF {
    public static final String OFFSET_FORMAT = "xxxx";
    public static final String TZ_SHORT_FORMAT = "v";
    public static final String TZ_LONG_FORMAT = "z";
    public static final String MONTH_SHORT_FORMAT = "MMM";
    public static final String MONTH_LONG_FORMAT = "MMMM";
    public static final String DOW_SHORT_FORMAT = "eee";
    public static final String DOW_LONG_FORMAT = "eeee";

    public TimeUnits() {
        this.declaredArguments = new Argument[]{new Argument(false, "any", Key.date), new Argument(false, "string", Key.timezone), new Argument(false, "string", Key.locale)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Integer result;
        DateTime dateRef = null;
        if (arguments.get(Key.date) == null) {
            dateRef = new DateTime(LocalizationUtil.parseZoneId(arguments.getAsString(Key.timezone), context));
        } else {
            dateRef = DateTimeCaster.cast(arguments.get(Key.date), true, LocalizationUtil.parseZoneId(arguments.getAsString(Key.timezone), context));
            if (arguments.get(Key.timezone) != null) {
                dateRef = dateRef.clone(ZoneId.of(arguments.getAsString(Key.timezone)));
            }
        }
        Locale locale = LocalizationUtil.parseLocaleFromContext(context, arguments);
        Key bifMethodKey = arguments.getAsKey(BIF.__functionName);
        String methodName = null;
        if (BIFMethods.MEMBER_METHODS.containsKey(bifMethodKey)) {
            methodName = (String)BIFMethods.MEMBER_METHODS.get(bifMethodKey);
            return dateRef.dereferenceAndInvoke(context, Key.of(methodName), arguments, (Boolean)false);
        }
        Object object = bifMethodKey.equals(BIFMethods.quarter) ? Integer.valueOf(dateRef.getWrapped().get(IsoFields.QUARTER_OF_YEAR)) : (bifMethodKey.equals(BIFMethods.month) ? Integer.valueOf(dateRef.getWrapped().getMonth().getValue()) : (bifMethodKey.equals(BIFMethods.monthAsString) ? dateRef.clone().format(MONTH_LONG_FORMAT) : (bifMethodKey.equals(BIFMethods.monthShortAsString) ? dateRef.clone().format(MONTH_SHORT_FORMAT) : (bifMethodKey.equals(BIFMethods.day) ? Integer.valueOf(dateRef.getWrapped().getDayOfMonth()) : (bifMethodKey.equals(BIFMethods.dayOfWeek) ? Integer.valueOf(locale == null ? dateRef.clone().getWrapped().getDayOfWeek().getValue() : dateRef.getWrapped().get(WeekFields.of(locale).dayOfWeek())) : (bifMethodKey.equals(BIFMethods.dayOfWeekAsString) ? dateRef.clone().format(DOW_LONG_FORMAT) : (bifMethodKey.equals(BIFMethods.dayOfWeekShortAsString) ? dateRef.clone().format(DOW_SHORT_FORMAT) : (bifMethodKey.equals(BIFMethods.daysInMonth) ? Integer.valueOf(dateRef.getWrapped().getMonth().length(dateRef.isLeapYear())) : (bifMethodKey.equals(BIFMethods.daysInYear) ? Integer.valueOf(Year.of(dateRef.getWrapped().getYear()).length()) : (bifMethodKey.equals(BIFMethods.firstDayOfMonth) ? Integer.valueOf(dateRef.getWrapped().withDayOfMonth(1).getDayOfYear()) : (bifMethodKey.equals(BIFMethods.week) ? Integer.valueOf(locale == null ? dateRef.getWrapped().get(ChronoField.ALIGNED_WEEK_OF_YEAR) : dateRef.getWrapped().get(WeekFields.of(locale).weekOfWeekBasedYear())) : (bifMethodKey.equals(BIFMethods.millis) ? Integer.valueOf(dateRef.getWrapped().getNano() / 1000000) : (bifMethodKey.equals(BIFMethods.offset) ? dateRef.clone().format(OFFSET_FORMAT) : (bifMethodKey.equals(BIFMethods.getNumericDate) ? (Number)(dateRef.clone().setTimezone(ZoneId.of("UTC")).toEpochMillis().doubleValue() / LongCaster.cast(86400000L).doubleValue()) : (Number)(bifMethodKey.equals(BIFMethods.getTime) ? (Number)dateRef.toEpochMillis() : (Number)(result = bifMethodKey.equals(BIFMethods.timeZone) || bifMethodKey.equals(BIFMethods.getTimeZone) ? dateRef.clone().format(TZ_SHORT_FORMAT) : null))))))))))))))));
        if (result == null) {
            throw new BoxRuntimeException(String.format("The method [%s] is not present in the [%s] object", arguments.getAsString(BIF.__functionName), dateRef.getClass().getSimpleName()));
        }
        return result;
    }

    protected static final class BIFMethods {
        public static final Key quarter = Key.quarter;
        public static final Key month = Key.month;
        public static final Key monthAsString = Key.of("monthAsString");
        public static final Key monthShortAsString = Key.of("monthShortAsString");
        public static final Key day = Key.day;
        public static final Key dayOfWeek = Key.of("dayOfWeek");
        public static final Key dayOfWeekAsString = Key.of("dayOfWeekAsString");
        public static final Key dayOfWeekShortAsString = Key.of("dayOfWeekShortAsString");
        public static final Key daysInMonth = Key.of("daysInMonth");
        public static final Key daysInYear = Key.of("daysInYear");
        public static final Key firstDayOfMonth = Key.of("firstDayOfMonth");
        public static final Key week = Key.of("week");
        public static final Key millis = Key.millisecond;
        public static final Key offset = Key.of("offset");
        public static final Key timeZone = Key.timezone;
        public static final Key getTimeZone = Key.of("getTimeZone");
        public static final Key getNumericDate = Key.of("getNumericDate");
        public static final Key getTime = Key.of("getTime");
        public static final IStruct MEMBER_METHODS = Struct.of(new Object[]{"Year", "getYear", "Day", "getDayOfMonth", "DayOfYear", "getDayOfYear", "Hour", "getHour", "Minute", "getMinute", "Second", "getSecond", "Nanosecond", "getNano"});

        protected BIFMethods() {
        }
    }
}

