/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.type;

import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxBIFs;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.bifs.BoxMembers;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.DateTimeCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIFs(value={@BoxBIF, @BoxBIF(alias="StructCount"), @BoxBIF(alias="ArrayLen"), @BoxBIF(alias="StringLen"), @BoxBIF(alias="QueryRecordCount")})
@BoxMembers(value={@BoxMember(type=BoxLangType.STRUCT, name="count"), @BoxMember(type=BoxLangType.STRUCT, name="len"), @BoxMember(type=BoxLangType.DATETIME, name="len"), @BoxMember(type=BoxLangType.DATE, name="len"), @BoxMember(type=BoxLangType.ARRAY), @BoxMember(type=BoxLangType.STRING), @BoxMember(type=BoxLangType.QUERY)})
public class Len
extends BIF {
    public Len() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.value)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Object string;
        Object array;
        Object query;
        Object object = arguments.get(Key.value);
        Object struct = arguments.get("struct");
        if (struct != null) {
            object = struct;
        }
        if ((query = arguments.get("query")) != null) {
            object = query;
        }
        if ((array = arguments.get("array")) != null) {
            object = array;
        }
        if ((string = arguments.get("string")) != null) {
            object = string;
        }
        if (object == null) {
            return 0;
        }
        if (object instanceof Query) {
            Query q = (Query)object;
            return q.size();
        }
        if (object instanceof DateTime) {
            DateTime dt = (DateTime)object;
            return dt.toString().length();
        }
        CastAttempt<DateTime> dateTimeAttempt = DateTimeCaster.attempt(object);
        if (dateTimeAttempt.wasSuccessful()) {
            return dateTimeAttempt.get().toString().length();
        }
        CastAttempt<Array> arrayAttempt = ArrayCaster.attempt(object);
        if (arrayAttempt.wasSuccessful()) {
            return arrayAttempt.get().size();
        }
        CastAttempt<IStruct> structAttempt = StructCaster.attempt(object);
        if (structAttempt.wasSuccessful()) {
            return structAttempt.get().size();
        }
        CastAttempt<String> stringAttempt = StringCaster.attempt(object);
        if (stringAttempt.wasSuccessful()) {
            return stringAttempt.get().length();
        }
        throw new BoxRuntimeException("Cannot determine length of object of type " + object.getClass().getName());
    }
}

