/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.type;

import java.util.Map;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

@BoxBIF(documented=false)
public class TranspileCollectionKeySwap
extends BIF {
    public TranspileCollectionKeySwap() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.collection), new Argument(true, "Struct", Key.keyMap)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        Object oCollection = arguments.get(Key.collection);
        CastAttempt<IStruct> structAttempt = StructCaster.attempt(oCollection);
        if (!structAttempt.wasSuccessful()) {
            return oCollection;
        }
        IStruct collection = structAttempt.get();
        IStruct newCollection = Struct.fromMap(collection);
        IStruct keyMap = arguments.getAsStruct(Key.keyMap);
        for (Map.Entry<Key, Object> keySet : keyMap.entrySet()) {
            Key fromKey = keySet.getKey();
            Key toKey = Key.of(keySet.getValue().toString());
            if (!newCollection.containsKey(fromKey)) continue;
            Object value = newCollection.get(fromKey);
            newCollection.remove(fromKey);
            newCollection.put(toKey, value);
        }
        return newCollection;
    }
}

