/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.xml;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.XML;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
public class XMLElemNew
extends BIF {
    public XMLElemNew() {
        this.declaredArguments = new Argument[]{new Argument(true, "xml", Key.XML), new Argument(true, "string", Key.childname), new Argument(false, "string", Key.namespace)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        XML xmlObject = arguments.getAsXML(Key.XML);
        String childName = arguments.getAsString(Key.childname);
        String namespace = arguments.getAsString(Key.namespace);
        Node documentNode = xmlObject.getNode();
        if (documentNode == null) {
            String xmlString = null;
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                xmlString = namespace != null ? "<" + childName + " xmlns=\"" + namespace + "\"/>" : "<" + childName + "/>";
                return builder.parse(new InputSource(new StringReader(xmlString)));
            }
            catch (ParserConfigurationException e) {
                throw new BoxRuntimeException("Error creating XML parser", e);
            }
            catch (SAXException e) {
                throw new BoxRuntimeException("Error parsing XML elemement" + xmlString, e);
            }
            catch (IOException e) {
                throw new BoxRuntimeException("Error parsing XML element" + xmlString, e);
            }
        }
        if (namespace != null) {
            Document ownerDocument = documentNode.getOwnerDocument() == null ? (Document)documentNode : documentNode.getOwnerDocument();
            return ownerDocument.createElementNS(namespace, childName);
        }
        Document ownerDocument = documentNode.getOwnerDocument() == null ? (Document)documentNode : documentNode.getOwnerDocument();
        return ownerDocument.createElement(childName);
    }
}

