/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.xml;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.w3c.dom.NodeList;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.XML;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

@BoxBIF
@BoxMember(type=BoxLangType.XML)
public class XMLSearch
extends BIF {
    public XMLSearch() {
        this.declaredArguments = new Argument[]{new Argument(true, "XML", Key.XMLNode), new Argument(true, "String", Key.xpath), new Argument(false, "Struct", Key.params, Struct.EMPTY)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        XML xml = arguments.getAsXML(Key.XMLNode);
        String xpathString = arguments.getAsString(Key.xpath);
        final IStruct params = arguments.getAsStruct(Key.params);
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            xpath.setXPathVariableResolver(new XPathVariableResolver(){

                @Override
                public Object resolveVariable(QName variableName) {
                    return params.get(Key.of(variableName.getLocalPart()));
                }
            });
            XPathExpression expression = xpath.compile(xpathString);
            Object result = expression.evaluate(xml.getNode(), XPathConstants.NODESET);
            Array results = new Array();
            if (result instanceof NodeList) {
                NodeList nodeList = (NodeList)result;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    results.append(new XML(nodeList.item(i)));
                }
            }
            return results;
        }
        catch (XPathExpressionException e) {
            throw new BoxRuntimeException("Invalid XPath: " + xpathString, e);
        }
    }
}

