/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.bifs.global.xml;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import ortus.boxlang.runtime.bifs.BIF;
import ortus.boxlang.runtime.bifs.BoxBIF;
import ortus.boxlang.runtime.bifs.BoxMember;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.XML;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.util.FileSystemUtil;

@BoxBIF
@BoxMember(type=BoxLangType.XML)
public class XMLTransform
extends BIF {
    public XMLTransform() {
        this.declaredArguments = new Argument[]{new Argument(true, "any", Key.XML), new Argument(true, "String", Key.XSL), new Argument(false, "Struct", Key.parameters, Struct.EMPTY)};
    }

    @Override
    public Object _invoke(IBoxContext context, ArgumentsScope arguments) {
        XML xmlCast;
        Object xmlAny = arguments.get(Key.XML);
        XML xml = xmlAny instanceof XML ? (xmlCast = (XML)xmlAny) : new XML(StringCaster.cast(xmlAny));
        String xsl = arguments.getAsString(Key.XSL);
        if (!xsl.trim().startsWith("<")) {
            xsl = StringCaster.cast(FileSystemUtil.read(xsl));
        }
        IStruct parameters = arguments.getAsStruct(Key.parameters);
        try {
            Document document = (Document)xml.getNode();
            StreamSource xslt = new StreamSource(new StringReader(xsl));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(xslt);
            for (Key key : parameters.keySet()) {
                transformer.setParameter(key.getName(), parameters.get(key));
            }
            DOMSource source = new DOMSource(document);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new BoxRuntimeException("Error transforming XML", e);
        }
    }
}

